# Lineage and Heritage

## Lineages

### Beastkin Lineage Traits

Your beastkin character has the following hereditary traits.

**_Age._** Beastkin mature far more quickly than most Humanoids, reaching adulthood within 5 years. Though they may live nearly a century, some beastkin live only 20 or 30 years.

**_Size._** Your size is Medium or Small. Beastkin vary in weight and height, depending on their Beast characteristics. Most are between 4 and 8 feet tall, but if you choose to play a beastkin shorter than 4 feet, you can choose your size to be Small. Your weight varies depending on your Beast characteristics. For example, a Medium beastkin descended from bears likely weighs upward of 350 pounds, while an avian beastkin of the same size is likely to weigh around 100 pounds.

**_Speed._** Your base walking speed is 30 feet.

**_Animal Instinct._** You have proficiency in either the Perception or Survival skill (your choice).

**_Natural Weapons._** You have claws, horns, hooves, fangs, spines, or a similar adaptation that serves as a natural weapon. Work with your GM to determine what type of natural weapon you possess and decide whether it does bludgeoning, piercing, or slashing damage. You can use your natural weapon to make unarmed strikes. When you hit with it, the strike deals 1d6 + your STR or DEX modifier damage (choose which during character creation) of your chosen type, instead of the bludgeoning damage normal for an unarmed strike.

**_Natural Adaptation._** You inherit one of the following traits determined by what kind of animal characteristics you want your character to have:

- **_Avian._** Leathery, feathery, or gossamer wings sprout from your back or connect to your outstretched arms. You have a flying speed equal to your walking speed. You can't fly while wearing medium or heavy armor. Carrying a heavy load or a creature of your size or larger while flying reduces your speed by half.
- **_Agile._** Sharp claws, cloven hooves, robust limbs, reversed joints, or suction pads on your hands and feet allow you to scrabble up trees, rock faces, and uneven surfaces with ease. You have a climbing speed equal to your walking speed. In addition, you have advantage on saves made to avoid being knocked prone.
- **_Aquatic._** Oily fur, scales, fins, webbed hands and feet, or long, gangly limbs are common for your people. You have a swimming speed equal to your walking speed. You can hold your breath for up to 20 minutes.
- **_Sturdy._** Powerful limbs, fat reserves, or a thick hide allow you to endure harm and accomplish feats of remarkable athleticism. When you aren't wearing armor, you have a natural AC of 13 + your DEX modifier. In addition, you count as one size larger when determining your carrying capacity and the weight you can push or drag.

### Dwarf Lineage Traits

Your dwarf character has the following hereditary traits.

**_Age._** Dwarves are physically mature around age 20, but most consider themselves young until they reach age 50. On average, they live about 350 years.

**_Size._** Your size is Medium. Dwarves vary little in height or size, with most standing between 4 and 5 feet tall. Even the smallest dwarves possess broad frames and rarely weigh less than 150 pounds.

**_Speed._** Your base walking speed is 30 feet. Darkvision. You have darkvision to a range of 60 feet. Dwarven Resilience. You have advantage on saves against becoming poisoned, and you are resistant to poison damage.

**_Dwarven Toughness._** Your hit point maximum increases by 1, and it increases by 1 every time you gain a level.

### Elf Lineage Traits

Your elf character has the following hereditary traits.

**_Age._** Although elves reach physical maturity around age 20, mental and emotional faculties reach full maturity around the age of 100. Elves can live to be 750 years old.

**_Size._** Your size is Medium. Elves range from under 5 feet to over 6 feet tall and tend toward slender builds, averaging around 110 pounds.

**_Speed._** Your base walking speed is 30 feet.

**_Heightened Senses._** You have advantage on Perception checks that rely on sight or hearing. You can see through lightly obscured areas normally and areas of dim light as if it were bright light.

**_Magic Ancestry._** You have advantage on saves against being charmed, and magic can't put you to sleep.

**_Trance._** Elves don't need to sleep. Instead, they enter a meditative trance state, remaining semiconscious for 4 hours a day. You choose whether or not you can dream while meditating. After resting in this way, you gain the same benefit that other creatures do from 8 hours of sleep.

### Human Lineage Traits

Your human character has the following hereditary traits.

**_Age._** Humans reach adulthood in their late teenage years and rarely live to be more than 100 years old.

**_Size._** Your size is Medium or Small. Humans vary in height and weight, but most adults range between 5 feet and 6 feet tall and average around 150 pounds. If you choose to play a human shorter than 4 feet however, you can choose your size to be Small.

**_Speed._** Your base walking speed is 30 feet. Ambitious. You gain proficiency in one skill of your choice, and you gain one talent of your choice. This talent can be from any of the talent lists, but you must meet the talent's prerequisites if any are required.

### Orc Lineage Traits

Your orc character has the following hereditary traits.

**_Age._** Orcs reach adulthood within two decades and seldom live longer than 60 years. However, orcs remain in their prime for most of their lives, undergoing few physical changes or signs of aging between adulthood and the end of their natural lifespan.

**_Size._** Your size is Medium. Orcs stand between 6 and 8 feet tall and commonly range from 110 to 350 pounds in weight.

**_Speed._** Your base walking speed is 30 feet.

**_Heightened Senses._** You have advantage on Perception checks that rely on sight or hearing. You can see through lightly obscured areas normally and areas of dim light as if it were bright light.

**_Orcish Perseverance._** When you would die due to suffocating or gaining levels of exhaustion, you instead enter a death-like stasis. While in stasis you are incapacitated, can't move, can't speak, and are unaware of your surroundings. You also cease to age, and your body is protected from decay. You can remain in this state until you are restored by mundane or magical healing, or your body is completely destroyed.

**_Stalwart._** When you are subjected to an effect that requires you to make a save at the end of your turn, you can instead choose to make the save at the start of your turn.

### Smallfolk Lineage Traits

Your smallfolk character has the following hereditary traits.

**_Age._** Smallfolk reach adulthood around 20 and typically live to be around 150 years old, though gnomes sometimes live twice as long.

**_Size._** Your size is Small. Smallfolk are rarely more than 3 feet tall and average about 40 pounds.

**_Speed._** Your base walking speed is 30 feet.

**_Grounded._** Once per day, when you fail a save, you can reroll the die and use the new roll. Regardless of whether the new roll is a success or failure, you generate 1 Luck.

**_Small Stature._** You can move through the space of any creature that is Medium or larger size. You can also attempt to hide when you are obscured by a creature of Medium or larger size.

**_Natural Adaptation._** You inherited one of the following unique traits, determined by whether your characteristics are gnomish or halfling:

- **_Gnomish._** Your ancestors made their homes underground or in dark woodlands, providing you with darkvision to a range of 60 feet. In addition, you learn the minor illusion cantrip. Choose whether INT, WIS, or CHA is your spellcasting ability for this spell during character creation.
- **_Halfling._** Your ancestors made their homes on the surface, displaying outsized pluck to drive back hostile wildlife and monsters. You have advantage on saves against being charmed or frightened.

## Heritages

### Cosmopolitan Heritage

**_Street Smarts._** While in a city or other urban environment, you have advantage on ability checks made to avoid getting lost and checks made to find a particular kind of business or other destination open to the public. In addition, while you are in such environments, you can't be surprised unless you are asleep or otherwise incapacitated.

**_Worldly Wisdom._** You have proficiency with the History skill. When you make a check related to understanding the purpose or significance of a building, rite, or object from a culture you aren't familiar with, you can add your PB to the roll. If you have proficiency in a relevant skill or tool, double your PB for the roll.

**_Languages._** You know Common and three additional languages of your choice. Typical cosmopolitan heritage characters choose Dwarvish and Elvish.

### Cottage Heritage

**_Comforts of Home._** As part of a long rest, you can cook a meal, tell stories, or perform some other activity that comforts your allies. Choose a number of creatures who participated in the long rest equal to your PB (this can include you). Those creatures gain temporary HP equal to twice your PB. These temporary HP last until expended or until you complete your next long rest.

**_Homesteader._** You have proficiency in either the Animal Handling or Nature skill.

**_Languages._** You know Common and one additional language of your choice. Typical cottage heritage characters choose Halfling or Gnomish.

### Diaspora Heritage

**_Preserved Traditions._** You gain proficiency with the History skill. You also gain proficiency with one type of martial weapon of your choice.

**_Timeless Resolve._** When you or an allied creature within 5 feet of you makes a save against becoming frightened, you and the ally have advantage on the save.

**_Languages._** You know Common and one additional language of your choice. Many diaspora communities learn the languages most common to soldiers, mercenaries, and traders near the area in which they reside, most often Orcish or Dwarven.

### Grove Heritage

**_Canopy Walker._** You have a climbing speed equal to your walking speed.

**_Nature's Camouflage._** You have advantage on DEX (Stealth) checks made while you are lightly obscured by foliage, heavy rain, falling snow, mist, and other natural phenomena. While in such conditions, you can always attempt to take the Hide action, even if circumstances would not normally allow you to do so.

**_Languages._** You know Common and one additional language of your choice. Typical grove heritage characters choose Elvish.

### Nomadic Heritage

**_Resilient._** You have advantage on checks or saves made to resist debilitating weather effects, such as those caused by extreme heat or cold. In addition, when you complete a short rest, you can reduce your exhaustion level by one. Once used, you can't reduce your exhaustion level in this way again until you complete a long rest.

**_Traveler._** You have proficiency in the Survival skill.

**_Languages._** You know Common and one additional language of your choice. Depending on the regions your people frequent or the kinds of communities your people trade with, typical nomadic heritage characters choose Dwarvish or Elvish.

### Slayer Heritage

**_Natural Predator._** You have proficiency in the Intimidation skill. You have advantage on Intimidation checks to influence Beasts and creatures with the Animal tag.

**_Tracker._** When you make a check to locate, spot, or track a creature, you can add your PB to the roll. If you have proficiency in the skill or tool being used, double your PB for the roll.

**_Languages._** You know Common and one additional language of your choice. Typical slayer heritage characters choose Primordial or Sylvan.

### Stone Heritage

**_Ancestral Arts._** You gain proficiency with Construction tools. Double your PB for any ability check you make that uses them. You also gain proficiency with one type of martial weapon of your choice.

**_Eye for Quality._** When you make an ability check related to the origin or purpose of an object or structure made of metal or stone, you can add your PB to the roll. If you have proficiency in a relevant skill or tool, double your PB for the roll.

**_Languages._** You know Common and one additional language of your choice. Typical stone heritage characters choose Dwarvish.

### Supplicant Heritage

**_Scurry._** As a bonus action, you can move up to 10 feet without provoking opportunity attacks. This movement doesn't trigger traps or hazards that you are aware of, even if they are armed.

**_Supplicant._** You have proficiency in either the Insight or Persuasion skill. When a creature within 30 feet of you spends Doom, you have advantage on ability checks and saves until the beginning of your next turn.

**_Languages._** You know Common and one additional language of your choice, typically the language favored by your current or previous overlord (such as Draconic, Giant, or Undercommon).

### Wildlands Heritage

**_Beast Affinity._** Using gestures and sounds, you can communicate simple ideas with Beasts and creatures with the Animal tag, and you have advantage on checks made to interact with such creatures.

**_Shepherd's Gift._** You have proficiency in the Animal Handling skill. Any Beast or creature with the Animal tag whose CR is equal to or less than your PB that targets you with an attack must first make a WIS check contested by your WIS (Animal Handling). If you succeed, the creature must choose a new target or lose the attack.

**_Languages._** You know Common and one additional language of your choice. Typical wildlands heritage characters choose Sylvan.
